<?php

/**
 * This is the model class for table "SzkolenieZlecenie".
 *
 * The followings are the available columns in table 'SzkolenieZlecenie':
 * @property double $idSzkoleniePytaniaEgzamin
 * @property double $idZlecenie
 */

class SzkolenieZlecenie extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SzkolenieOdpowiedziFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'SzkolenieZlecenie';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idSzkoleniePytaniaEgzamin, idZlecenie', 'numerical'),
			array('idSzkoleniePytaniaEgzamin, idZlecenie', 'safe'),
		);
	}

	public function primaryKey()
	{
		return array('idSzkoleniePytaniaEgzamin', 'idZlecenie');
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'pytanieEgzaminacyjne' => array(self::BELONGS_TO, 'SzkoleniePytaniaEgzamin', 'idSzkoleniePytaniaEgzamin'),
			'zlecenie'=>array(self::BELONGS_TO, 'Zlecenie', 'idZlecenie'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array();
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('idSzkoleniePytaniaEgzamin', $this->idSzkoleniePytaniaEgzamin);
		$criteria->compare('idSzkoleniePytaniaEgzamin', $this->idZlecenie);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
